/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.moduleviews;

import com.ldtteam.blockout.views.Window;
import com.minecolonies.api.colony.buildings.modules.AbstractBuildingModuleView;
import com.minecolonies.api.colony.buildings.modules.IItemListModuleView;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.client.gui.modules.ItemListModuleWindow;
import com.minecolonies.coremod.network.messages.server.colony.building.AssignFilterableItemMessage;
import com.minecolonies.coremod.network.messages.server.colony.building.ResetFilterableItemMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class ItemListModuleView
extends AbstractBuildingModuleView
implements IItemListModuleView {
    private final List<ItemStorage> listsOfItems = new ArrayList<ItemStorage>();
    private final String id;
    private final Function<IBuildingView, Set<ItemStorage>> allItems;
    private final boolean inverted;
    private final String desc;

    public ItemListModuleView(String id, String desc, boolean inverted, Function<IBuildingView, Set<ItemStorage>> allItems) {
        this.id = id;
        this.desc = desc;
        this.inverted = inverted;
        this.allItems = allItems;
    }

    @Override
    public void addItem(ItemStorage item) {
        Network.getNetwork().sendToServer(new AssignFilterableItemMessage(this.buildingView, this.id, item, true));
        this.listsOfItems.add(item);
    }

    @Override
    public boolean isAllowedItem(ItemStorage item) {
        return this.listsOfItems.contains(item);
    }

    @Override
    public int getSize() {
        return this.listsOfItems.size();
    }

    @Override
    public void removeItem(ItemStorage item) {
        Network.getNetwork().sendToServer(new AssignFilterableItemMessage(this.buildingView, this.id, item, false));
        this.listsOfItems.remove(item);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Function<IBuildingView, Set<ItemStorage>> getAllItems() {
        return this.allItems;
    }

    @Override
    public boolean isInverted() {
        return this.inverted;
    }

    @Override
    public void clearItems() {
        Network.getNetwork().sendToServer(new ResetFilterableItemMessage(this.buildingView, this.id));
        this.listsOfItems.clear();
    }

    @Override
    public String getDesc() {
        return this.desc;
    }

    @Override
    public void deserialize(@NotNull PacketBuffer buf) {
        this.listsOfItems.clear();
        int size = buf.readInt();
        for (int j = 0; j < size; ++j) {
            this.listsOfItems.add(new ItemStorage(buf.func_150791_c()));
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Window getWindow() {
        return new ItemListModuleWindow("minecolonies:gui/layouthuts/layoutfilterablelist.xml", this.buildingView, this);
    }

    @Override
    public String getIcon() {
        return this.getId();
    }
}

